<%@ Application Language="VB" %>
<%@ Import Namespace="System.Net.Mail" %>
<script runat="server">

    Sub Application_Start(ByVal sender As Object, ByVal e As EventArgs)
        ' Code that runs on application startup
    End Sub
    
    Sub Application_End(ByVal sender As Object, ByVal e As EventArgs)
        ' Code that runs on application shutdown
    End Sub
        
  Sub Application_Error(ByVal sender As Object, ByVal e As EventArgs)
    ' Fires when an error occurs
    Dim sendMailOnErrors As Boolean = False
    If sendMailOnErrors Then
      Dim subject As String = "Error in page " & Request.Url.ToString()
      Dim errorMessage As StringBuilder = New StringBuilder
      ' The error that occurred in the web page is wrapped by a generic System.Web.HttpUnhandledException exception
      ' Therefore we need to get at the true exception, available on the InnerException
      Dim myException As Exception = HttpContext.Current.Server.GetLastError().GetBaseException()
      If myException IsNot Nothing Then
        errorMessage.Append("<strong>Message</strong><br />" & _
              myException.Message & "<br /><br />")
        errorMessage.Append("<strong>Source</strong><br />" & _
            myException.Source & "<br /><br />")
        errorMessage.Append("<strong>Target site</strong><br />" & _
            myException.TargetSite.ToString() & "<br /><br />")
        errorMessage.Append("<strong>Stack trace</strong><br />" & _
            myException.StackTrace & "<br /><br />")
        errorMessage.Append("<strong>ToString()</strong><br />" & _
            myException.ToString() & "<br /><br />")
      Else
        errorMessage.Append("No exception information available.")
      End If

      ' With the errorMessage built, sent out the email.
      Dim mySmtpClient As SmtpClient = New SmtpClient()
      Dim myMessage As MailMessage = New MailMessage( _
          "You@YourProvider.Com", "You@YourProvider.Com", subject, _
          errorMessage.ToString())
      myMessage.IsBodyHtml = True

      mySmtpClient.Send(myMessage)
    End If
  End Sub

    Sub Session_Start(ByVal sender As Object, ByVal e As EventArgs)
        ' Code that runs when nowy session is started
    End Sub

    Sub Session_End(ByVal sender As Object, ByVal e As EventArgs)
        ' Code that runs when a session ends. 
        ' Note: The Session_End event is raised only when the sessionstate mode
        ' is set to InProc in the Web.config file. If session mode is set to StateServer 
        ' or SQLServer, the event is not raised.
    End Sub
       
</script>